
#import <AppKit/AppKit.h>
#import "MCBindingSupport.h"
#import "MCBinding.h"


extern NSString *MCUpdatedValueInModelNotification;
// notification sent by individuals bindings. notifications are coallesed 
// in the default notification queue so an observer shouldn't get too many
// of these -- at least that's the theory ...



@protocol MCBinderValidation

- (id)bindingFor:aModel andAttribute:(NSString *)anAttribute;
- (BOOL)hasBindingFor:aModel andAttribute:(NSString *)anAttribute;
- (BOOL)selectUIForModel:aModel andAttribute:(NSString *)anAttribute;

@end



@interface MCBinder:NSObject <MCBinderValidation, MCBinderProto, NSCoding>
{
    id					delegate;
    id					model;
    NSMutableArray		*bindings;
    BOOL 				isHelper;
	BOOL				textDirty;

	BOOL				editorDidFinishChangingWithDelay;
}

// FACTORY METHODS

+ (void)initialize;

// INSTANCE METHODS

- (void)resetModelIfPresent;	// Used for special 'global' calls

- (void)updateModelFromVisibleInterface;
    //	Updates the model with the interface controls that are visible.


- (void)updateVisibleInterfaceFromModel;


- delegate;
- (void)setDelegate:(id)anObject;
- (NSArray *)bindings;

// removes all bindings
- (void)clearBindings;

- interfaceForAttribute: (NSString *)anAttribute;
// Calls interfaceForAttribute:inModel: with [self model] as the second parameter.
- interfaceForAttribute: (NSString *)anAttribute
                inModel: aModel;
    // Returns the interface for the given model and attribute.
    
    
- (BOOL)isHelper;
- (void)setIsHelper:(BOOL)flag;
    
// TARGET ACTION METHODS

- (void)takeValueFrom:sender;
- (void)reallyTakeValueFrom:sender;

- (void)bindAttribute:(NSString *)anAttribute
                   to:anInterfaceElement
           accessMode:(int)accessMode
        mandatoryFlag:(BOOL)mandatoryFlag
              tagFlag:(BOOL)tagFlag;


// NOTIF
- (void) registerForAllBindersNotification;



// TEXT DELEGATE METHODS

//- (BOOL)textShouldEndEditing:(NSText *)sender;
    
- (void)addErrorWithBinding:aBinding toErrorList:errorList;
- (void)triggerFormatterForUI:errorList;

// ACCESSORS
- (BOOL)editorDidFinishChangingWithDelay;
- (void)setEditorDidFinishChangingWithDelay:(BOOL)aBool;
@end

@interface NSObject (MCBinderDelegate)
- (void)binderDidFinishUpdatingBindings:(MCBinder *)aBinder;
@end

@interface NSObject (MCBinderModelMethods)
- (int)fieldWidthForAttributeNamed:(NSString *)aName;
@end

